<?php
session_start();
include('connection.php');

$searchIC = '';
if (!isset($_SESSION['search_results'])) {
    $_SESSION['search_results'] = [];
}

$masjid_id = $_SESSION['masjid_id'];
date_default_timezone_set('Asia/Kuala_Lumpur');
$current_date = date('Y-m-d');

$sql = "SELECT * FROM booking b 
        JOIN user u ON b.user_id = u.user_id
        JOIN masjid m ON u.masjid_id = m.masjid_id 
        WHERE b.date = :booking_date AND m.masjid_id = :masjid_id AND b.status_code = 1";

$stmt = $conn->prepare($sql);
$stmt->execute([
    'booking_date' => $current_date,
    'masjid_id' => $masjid_id
]);
$booking = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$booking) {
    header("Location: mainpage.php");
    exit();
}

try {
    $stmt = $conn->prepare("SELECT * FROM booking WHERE user_id = :user_id");
    $stmt->bindParam(':user_id', $_SESSION['user_id']);
    $stmt->execute();
    $bookings = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Error: " . $e->getMessage());
}

$sql = "SELECT f.*, u.name, u.ic, u.phone, u.address, u.job, u.masjid_id FROM form f 
        JOIN user u ON f.ic = u.ic
        JOIN masjid m ON u.masjid_id = m.masjid_id 
        WHERE DATE(f.reg_date) = :booking_date AND m.masjid_id = :masjid_id AND f.status_code = 1";

$stmt = $conn->prepare($sql);
$stmt->execute([
    'booking_date' => $current_date,
    'masjid_id' => $masjid_id
]);
$forms = $stmt->fetchAll(PDO::FETCH_ASSOC);

$existingICs = array_column($_SESSION['search_results'], 'ic');
foreach ($forms as &$form) {
    if (!isset($form['total_vote'])) { 
        $form['total_vote'] = 0;
    }
    if (!in_array($form['ic'], $existingICs)) {
        $_SESSION['search_results'][] = $form;
    }
}

try {
    $stmtMasjid = $conn->prepare("SELECT masjid_name FROM masjid WHERE masjid_id = ?");
    $stmtMasjid->execute([$masjid_id]);
    $masjidData = $stmtMasjid->fetch(PDO::FETCH_ASSOC);
    if (!$masjidData) {
        die("Error: Masjid not found.");
    }
    $masjidName = $masjidData['masjid_name'];
} catch (PDOException $e) {
    die("Error fetching data: " . $e->getMessage());
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['search_ic'])) {
    $searchIC = trim($_POST['search_ic']);
    if (!empty($searchIC)) {
        try {
            $stmt = $conn->prepare("SELECT nama_penuh AS username, nama_penuh AS pswd, nama_penuh AS name, 
                                   id_masjid AS masjid_id, jantina AS gender, no_ic AS ic, no_hp AS phone, 
                                   alamat_terkini AS address, pekerjaan AS job 
                                   FROM sej6x_data_peribadi WHERE no_ic = :ic");
            $stmt->execute(['ic' => $searchIC]);
            $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
            if ($results) {
                foreach ($results as &$user) {
                    if ($user['masjid_id'] != $masjid_id) {
                        echo "<script>alert('Anda Bukan Ahli Qaryah');</script>";
                        continue;
                    }
                    if (!isset($user['total_vote'])) { 
                        $user['total_vote'] = 0;
                    }
                    $existingICs = array_column($_SESSION['search_results'], 'ic');
                    if (!in_array($user['ic'], $existingICs)) {
                        $_SESSION['search_results'][] = $user;
                    } else {
                        echo "<script>alert('Warning: This IC is already in the table!');</script>";
                    }
                }
            } else {
                echo "<script>alert('No user found with this IC!');</script>";
            }
        } catch (PDOException $e) {
            echo "<script>alert('Error fetching data: " . addslashes($e->getMessage()) . "');</script>";
        }
    }    
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_vote'])) {
    $updateIC = $_POST['ic'];
    $newVote = intval($_POST['total_vote']);
    foreach ($_SESSION['search_results'] as &$user) {
        if ($user['ic'] === $updateIC) {
            $user['total_vote'] = $newVote;
            break;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CARIAN NAMA-NAMA CALON</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
</head>
<body>
    <?php require '../include/header.php'; ?>
    <div class="container d-flex flex-column align-items-center justify-content-center min-vh-80">
    <h1 class="text-center mb-4"><?php echo htmlspecialchars($masjidName); ?></h1>
    <h1 class="text-center mb-4">MESYUARAT AGUNG PENCALONAN JAWATANKUASA BAGI PENGGAL 2025-2028</h1>

    <div class="table-responsive">
        <table class="table table-bordered text-center">
            <thead class="table-primary text-white">
                <tr>
                    <th>TARIKH</th>
                    <th>MASA</th>
                    <th>TEMPAT</th>
                    <th>NAMA CADANGAN PENGERUSI MESYUARAT</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($bookings)): ?>
                    <tr><td colspan="7">TIADA DATA DIJUMPAI.</td></tr>
                <?php else: ?>
                    <tr>
                        <td><?php echo htmlspecialchars($booking['date']); ?></td>
                        <td><?php echo date('H:i', strtotime($booking['time'])); ?></td>
                        <td><?php echo htmlspecialchars($booking['place']); ?></td>
                        <td>
                            1.<?php echo htmlspecialchars($booking['nama_cadangan1']); ?>
                            <br>
                            2.<?php echo htmlspecialchars($booking['nama_cadangan2']); ?>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <div class="search-section text-center mb-4">
            <form method="POST" action="" class="d-flex justify-content-center align-items-center gap-2 w-100 mx-auto">
                <div class="d-flex align-items-center">
                    <label for="search_ic" class="me-2 mb-0">MASUKKAN NO KAD PENGENALAN:</label>
                    <input type="text" id="search_ic" name="search_ic" pattern="\d{12,}" maxlength="12" required class="form-control text-center w-75">
                </div>
                <button type="submit" class="btn btn-primary">CARI</button>
            </form>
        </div>

        <?php if (!empty($_SESSION['search_results'])): ?>
            <h2 class="text-center mt-4">HASIL CARIAN:</h2>
            <div class="table-responsive">
                <table class="table table-bordered text-center">
                    <thead class="table-primary text-white">
                        <tr>
                            <th>NO.</th>
                            <th>NAMA</th>
                            <th>JANTINA</th>
                            <th>NO KAD PENGENALAN</th>
                            <th>NO TELEFON</th>
                            <th>ALAMAT</th>
                            <th>PEKERJAAN</th>
                            <th>JUMLAH UNDI</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                            $counter = 1;
                            foreach ($_SESSION['search_results'] as $row): ?>
                            <tr>
                                <td><?php echo $counter++; ?></td>
                                <td><?php echo htmlspecialchars($row['name']); ?></td>
                                <td>
                                    <?php
                                    $genderId = $row['gender'];
                                    if ($genderId == 1) {
                                        echo 'LELAKI';
                                    } elseif ($genderId == 2) {
                                        echo 'PEREMPUAN';
                                    } 
                                    ?>
                                </td>
                                <td><?php echo htmlspecialchars($row['ic']); ?></td>
                                <td><?php echo htmlspecialchars($row['phone']); ?></td>
                                <td><?php echo htmlspecialchars($row['address']); ?></td>
                                <td><?php echo htmlspecialchars($row['job']); ?></td>
                                <td>
                                    <form method="POST" action="">
                                        <input type="hidden" name="ic" value="<?php echo htmlspecialchars($row['ic']); ?>">
                                        <input type="number" name="total_vote" min="1" value="<?php echo isset($row['total_vote']) ? htmlspecialchars($row['total_vote']) : '0'; ?>" required class="form-control w-50 mx-auto">
                                        <button type="submit" name="update_vote" class="btn btn-success btn-sm mt-2">SET UNDI</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <form id="nomination-form" method="POST" action="db_insert_form1.php" class="text-center">
                <?php foreach ($_SESSION['search_results'] as $row): ?>
                    <input type="hidden" name="users[<?php echo $row['ic']; ?>][ic]" value="<?php echo $row['ic']; ?>">
                    <input type="hidden" name="users[<?php echo $row['ic']; ?>][name]" value="<?php echo $row['name']; ?>">
                    <input type="hidden" name="users[<?php echo $row['ic']; ?>][masjid_id]" value="<?php echo $row['masjid_id']; ?>">
                    <input type="hidden" name="users[<?php echo $row['ic']; ?>][gender]" value="<?php echo $row['gender']; ?>">
                    <input type="hidden" name="users[<?php echo $row['ic']; ?>][phone]" value="<?php echo $row['phone']; ?>">
                    <input type="hidden" name="users[<?php echo $row['ic']; ?>][address]" value="<?php echo $row['address']; ?>">
                    <input type="hidden" name="users[<?php echo $row['ic']; ?>][job]" value="<?php echo $row['job']; ?>">
                    <input type="hidden" name="users[<?php echo $row['ic']; ?>][booking_id]" value="<?php echo $_GET['booking_id']; ?>">
                    <input type="hidden" name="users[<?php echo $row['ic']; ?>][total_vote]" min="1" value="<?php echo isset($row['total_vote']) ? $row['total_vote'] : '0'; ?>" required>
                <?php endforeach; ?>
                <button type="button" id="submit-btn" class="btn btn-primary mt-3">SIMPAN</button>
            </form>
        <?php else: ?>
            <p class="text-center text-muted mt-4">MAKLUMAT CALON AKAN DIPAPARKAN DISINI.</p>
        <?php endif; ?>

        <?php require '../include/footer.php'; ?>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <script>
    $(document).ready(function() {
        $('#submit-btn').click(function(e) {
            e.preventDefault();
            
            Swal.fire({
                title: 'ADAKAH ANDA PASTI?',
                text: "BORANG PENCALONAN 1 TIDAK AKAN BOLEH DIUBAH SETELAH DIHANTAR.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#C64EB2',
                cancelButtonColor: '#d33',
                confirmButtonText: 'YA, SAYA PASTI',
                cancelButtonText: 'BATAL',
                allowOutsideClick: false
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({
                        title: 'PENGESAHAN TERAKHIR',
                        text: "SILA PASTIKAN SEMUA MAKLUMAT ADALAH TEPAT SEBELUM DIHANTAR KE BORANG PENCALONAN 2.",
                        icon: 'question',
                        showCancelButton: true,
                        confirmButtonColor: '#C64EB2',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'YA, HANTAR SEKARANG',
                        cancelButtonText: 'SEMAK SEMULA',
                        allowOutsideClick: false
                    }).then((finalResult) => {
                        if (finalResult.isConfirmed) {
                            // Submit form via AJAX
                            $.ajax({
                                url: $('#nomination-form').attr('action'),
                                type: 'POST',
                                data: $('#nomination-form').serialize(),
                                dataType: 'json',
                                success: function(response) {
                                    if (response.status === 'success') {
                                        Swal.fire({
                                            title: 'BERJAYA!',
                                            text: '10 CALON UNDIAN TERINGGI TELAH DIPINDAHKAN KE BORANG PENCALONAN 2!',
                                            icon: 'success',
                                            confirmButtonColor: '#C64EB2'
                                        }).then(() => {
                                            window.location.href = response.redirect;
                                        });
                                    } else {
                                        Swal.fire({
                                            title: 'Ralat',
                                            text: response.message,
                                            icon: 'error',
                                            confirmButtonColor: '#C64EB2'
                                        });
                                    }
                                },
                                error: function(xhr, status, error) {
                                    Swal.fire({
                                        title: 'Ralat',
                                        text: 'Terjadi kesalahan teknis. Sila cuba lagi.',
                                        icon: 'error',
                                        confirmButtonColor: '#C64EB2'
                                    });
                                }
                            });
                        }
                    });
                }
            });
        });
    });
    </script>
</body>
</html>